#!/bin/bash

# First API endpoint - returns an array of strings
API_URL="https://bscontrolapi/jobs"

# Second API endpoint - combine each element from the first API
SECOND_API_URL="https://bscontrolapi/jobs/"

# Directory to store the response files
SAVE_DIR="save_jobs"

# Check if the directory exists; if not, create it
if [ ! -d "$SAVE_DIR" ]; then
    echo "Directory '$SAVE_DIR' does not exist. Creating..."
    mkdir "$SAVE_DIR"
fi


# Fetch data from the first API
response=$(curl -s "$API_URL")

# Use jq to parse the response and extract the array of strings
array_of_strings=$(echo "$response" | jq -r '.[]')

for item in $array_of_strings; do
    echo "Processing job: $item"
    second_response=$(curl -s "$SECOND_API_URL$item")
    echo "$second_response" > "${SAVE_DIR}/${item}.json"
    echo "${SAVE_DIR}/${item}.json save"
done