var vm = require('vm');
var request = require('request').defaults({ encoding: null });

function execute_function(context,output,response){
  var job_id = context.jobconfig.job_id;
  var transaction_id = context.transaction.id;
  var param = context.jobconfig.data_out.param;
  var data = context.output.data;
  var meta = context.output.meta;

  var output_type = 'text';
  var url = param.url;
  var body = param.body;
  var env = {
    'output' : {
      'meta' : meta,
      'data' : data
    },
    'url' : '',
    'body':''
  }

  var script = new vm.Script("url=`" + url + "`;body=`" + body + "`");
  var context = new vm.createContext(env);
  script.runInContext(context);
  
  url = env.url;
  body = env.body;


  var reject = true;
  if(typeof param.reject != 'undefined' && param.reject.toString()=="false"){reject=false;}

  var encode = 'utf8'

  //Http Header
  var http_headers = {};
  if(param.auth){
    if(param.auth.type == 'basic'){
      var auth_header  = "Basic " + new Buffer(param.auth.username + ":" + param.auth.password).toString("base64");
      http_headers.Authorization = auth_header;
    }
  }

  
  if(typeof param.headers == 'object')
  {
    http_headers = Object.assign(http_headers,param.headers)
  }
  
  var method = param.method || 'GET'
  var option = {'method': method,'url':url,'headers':http_headers ,'encoding':encode}
  
  // Setup Body if POST or PUT
  if(method == 'POST' || method == 'PUT') {
    if(typeof param.body == 'object') {
        option.body = body 
    }
  }
  
  request(option, function (error, resp, body) {
    if (!error && resp.statusCode == 200) {
        response.success();
    }else if(!reject){
      response.success();
    }else{
      response.reject();
    }
  });


}

module.exports = execute_function;
