#!/usr/bin/env node

var Git = require("nodegit");
var fs = require('fs');

var temppath = "tmp"
const bspath = "../plugins/"

/*
    remove file script https://stackoverflow.com/a/32197381
*/
var deleteFolderRecursive = function(path) {
    if (fs.existsSync(path)) {
      fs.readdirSync(path).forEach(function(file, index){
        var curPath = path + "/" + file;
        if (fs.lstatSync(curPath).isDirectory()) { // recurse
          deleteFolderRecursive(curPath);
        } else { // delete file
          //console.log("remove file"+curPath)
          fs.unlinkSync(curPath);
        }
      });
      fs.rmdirSync(path);
    }
  };

console.log("BigStream plugin installer version 1.0")
console.log("**This script version support install from github repository only.**")

var args = process.argv.slice(2);

if(args.length == 0) {
    console.log("Missing git repository url")
} else {
    let url = args[0]

    // Remove any old tmp if exists
    deleteFolderRecursive(temppath);
    
    console.log("start git clone "+url)
    Git.Clone(url,temppath)
        .then((repo) => {
            var profile = require('./tmp/profile.json');
            var plugin_type = profile.type
            var plugin_name = profile.name

            if(!plugin_type || !plugin_name) {
                console.log("plugin profile not valid format.")
                console.log(profile);
                deleteFolderRecursive(temppath);
                return
            }
            var fdname = plugin_type+"-"+plugin_name

            // If already have plugin stop it
            if (fs.existsSync(bspath+plugin_type+'/'+fdname)) {
                console.log("Found plugin already exists in "+bspath+plugin_type+'/'+fdname)
                console.log("Exit")
                deleteFolderRecursive(temppath);
                return
            }

            console.log("copy to plugins directory")
            fs.renameSync(temppath,bspath+plugin_type+'/'+fdname);

            // Auto call update script
            console.log("run plugin installer script")
            var auto_install = require("./install_plugins")
            //console.log(profile); 
            return ;
        })
        .catch(function(err) { 
            console.log(err);
         });

}