const jwt = require('jsonwebtoken');
const express = require('express');
const bodyParser = require('body-parser')
const app = express();
const noKey = "nokey";
const secret = (process.env.BIGSTREAM_SIGNATURE) ? process.env.BIGSTREAM_SIGNATURE : noKey;
const port = (process.env.TOKEN_GENERATOR_PORT) ? process.env.TOKEN_GENERATOR_PORT : 3000;
const debug = (process.env.DEBUG_MODE) ? process.env.DEBUG_MODE : false;

app.set('view engine', 'ejs')
app.set('views', './public')

app.use(bodyParser.urlencoded({ // to support URL-encoded bodies
    extended: true
}))
app.use(bodyParser.json())
app.use(express.static("public"));

app.get('/', function(req, res) {
    // res.status(err.status);
    res.render('index', { token: '', name: '' })
});

app.get('/', (req, res) => {
    res.render('index', { token: '', name: '' })
})

app.post('/', function(req, res) {
    //console.log(req.body);
    res.render('index', { token: generateToken(req.body.name_field), name: req.body.name_field });
})

app.listen(port, () => console.log('App listening on port '+port+'!'))

function generateToken(name) {
    var templete = {
        "vo": "igrid",
        "acl": [{
            "accept": true,
            "resource": "igrid.*"
        }],
        "iat": Math.floor(Date.now() / 1000)
    };

    var expire = { "expiresIn": '0.5y' };

    var regex_name = /^[A-Za-z0-9]+$/;
    var check = regex_name.test(name);
    if (!check ) {
        return ("Please, enter only a-Z or 0-1 only.")
    }

    // Add blacklist name
    if (name.toLowerCase() == "bigstream" || name.toLowerCase() == "example") return ("Cannot use this name");
    
    var username = name
    templete.vo = username;
    templete.acl[0].resource = username + ".*";

    var token = jwt.sign(templete, secret, expire);


    if(debug) {
         console.log("before decode: "+JSON.stringify(templete)+"\n");
    }
    return token;
}
