const jwt = require('jsonwebtoken');
const express = require('express');
const bodyParser = require('body-parser')
const app = express();
const noKey = "nokey";
const secret = (process.env.BIGSTREAM_SIGNATURE) ? process.env.BIGSTREAM_SIGNATURE : noKey;


app.set('view engine', 'ejs')
app.set('views', './public')

app.use(bodyParser.urlencoded({ // to support URL-encoded bodies
    extended: true
}))
app.use(bodyParser.json())
app.use(express.static("public"));

app.get('/', function(req, res) {
    // res.status(err.status);
    res.render('index', { token: '', name: '' })
});

app.get('/', (req, res) => {
    res.render('index', { token: '', name: '' })
})

app.post('/', function(req, res) {
    //console.log(req.body);
    res.render('index', { token: generateToken(req.body.name_field), name: req.body.name_field });
})

// app.get('/', function(req, res) {
//     res.sendFile("index.html")
// })
// app.post('/', function(req, res) {
//     //console.log(req.body);
//     res.send(generateToken(req.body.name_field));
// })
app.listen(3000, () => console.log('App listening on port 3000!'))


function generateToken(name) {
    var templete = {
        "vo": "igrid",
        "acl": [{
            "accept": true,
            "resource": "igrid.*"
        }],
        "iat": Math.floor(Date.now() / 1000)
    };

    var expire = { "expiresIn": '0.5y' };

    var regex_name = /^[A-Za-z0-9]+$/;
    var check = regex_name.test(name);
    if (!check ) {
        return ("Please, enter only a-Z or 0-1 only.")
    }
    if (name.toLowerCase() == "bigstream" || name.toLowerCase() == "example") return ("Cannot use this name");
    
    var username = name
    templete.vo = username;
    templete.acl[0].resource = username + ".*";

    var token = jwt.sign(templete, secret, expire);

    // var body = "<body><div>You token is <blockquote>" + token + "</blockquote></div><div>" + JSON.stringify(jwt.verify(token, secret), true, 4) + "</div></body>"
         console.log("secret: "+secret+"\n");
    //     //console.log("before decode: "+JSON.stringify(templete)+"\n");
    // console.log(body);

    // var web = "<!DOCTYPE html><html lang='en'><center>" + body + "</center></html>"
    return token;
}
