# installation
```
git clone https://git.igridproject.info/gogogokrit/bigstream-token-generator.git 
```
# Setup and configuration
```
export BIGSTREAM_SIGNATURE=<BigStream secret key>  
export TOKEN_GENERATOR_PORT=<Port>  
cd bigstream-token-generator  
npm install  
```

# start service
```
node server.js
```
or
```
pm2 start server.js --name=BigStream-token-generator-$TOKEN_GENERATOR_PORT
```
open at http://host:TOKEN_GENERATOR_PORT/

# docker

build image
```
docker build -t bigstream-token-generator:latest .
```
run
```
docker run -d -p 3000:3000 --name bs_token bigstream-token-generator
```
# docker-compose
docker-compose.yml example
```
version: "3.8"

services:
  token-service:
    image: bigstream-token-generator:latest
    environment:
     - BIGSTREAM_SIGNATURE=${BS_SECRET}
     - TOKEN_GENERATOR_PORT=${PORT}
    ports:
     - ${HTTPPORT}:${PORT}
```
.env example
```
BS_SECRET=test
PORT=3000
HTTPPORT=1234
```