import face_recognition
import os
import re

def image_files_in_folder(folder):
    return [os.path.join(folder, f) for f in os.listdir(folder) if re.match(r'.*\.(jpg|jpeg|png)', f, flags=re.I)]

def load_face_db(known_people_folder):
    known_names = []
    known_face_encodings = []
    db = []
    rec = {}

    for file in image_files_in_folder(known_people_folder):
        basename = os.path.splitext(os.path.basename(file))[0]
        img = face_recognition.load_image_file(file)
        #encodings = face_recognition.face_encodings(img)
        encodings = face_recognition.face_locations(img, model="cnn")
        print('loading facedb >> ' + basename)

        if len(encodings) > 1:
            click.echo("WARNING: More than one face found in {}. Only considering the first face.".format(file))

        if len(encodings) == 0:
            click.echo("WARNING: No faces found in {}. Ignoring file.".format(file))
        else:
            #known_names.append(basename)
            #known_face_encodings.append(encodings[0])
            rec = {'name':basename.split('_')[0],'face_encoding':encodings[0]}
            db.append(rec)

    return db


######################################################################################
###################################### Main ##########################################

face_folder = '../facedb/nectec'
facedb = load_face_db(face_folder)

