import face_recognition
import cv2
import os
import re
import requests
import math
import base64


def send_to_bigstream(name,dist,feature,ba64frame,ba64lab):
    #requests.get('http://push02.igridproject.info/lsrface?name=' + name + '&distance=' + str(dist))
    requests.post('http://push02.igridproject.info/lsrface', json={"name": name,"distance":dist,"feature":feature,"img_raw":ba64frame,"img_label":ba64lab})

def image_files_in_folder(folder):
    return [os.path.join(folder, f) for f in os.listdir(folder) if re.match(r'.*\.(jpg|jpeg|png)', f, flags=re.I)]

def load_face_db(known_people_folder):
    known_names = []
    known_face_encodings = []
    db = []
    rec = {}

    for file in image_files_in_folder(known_people_folder):
        basename = os.path.splitext(os.path.basename(file))[0]
        img = face_recognition.load_image_file(file)
        encodings = face_recognition.face_encodings(img)

        print 'loading facedb >> ' + basename

        if len(encodings) > 1:
            click.echo("WARNING: More than one face found in {}. Only considering the first face.".format(file))

        if len(encodings) == 0:
            click.echo("WARNING: No faces found in {}. Ignoring file.".format(file))
        else:
            #known_names.append(basename)
            #known_face_encodings.append(encodings[0])
            rec = {'name':basename.split('_')[0],'face_encoding':encodings[0]}
            db.append(rec)

    return db

def find_face(face_db,prefer_face):
    res=False
    dist=1
    name='unknown'

    for rec in face_db:
        dd = face_recognition.face_distance(rec['face_encoding'],[prefer_face])
        if dd[0] < dist:
            res=True
            dist=dd[0]
            name=rec['name']

        if dist > 0.5:
            res=False

    return {'match':res,'name':name,'distance':dist}

def label_frame(frame,face_locations,face_names):
    labframe = frame
    # Display the results
    for (top, right, bottom, left), name in zip(face_locations, face_names):
        # Scale back up face locations since the frame we detected in was scaled to 1/2 size
        top *= 1
        right *= 1
        bottom *= 1
        left *= 1

        # Draw a box around the face
        cv2.rectangle(labframe, (left, top), (right, bottom), (0, 0, 255), 1)

        # Draw a label with a name below the face
        #cv2.rectangle(frame, (left, bottom - 35), (right, bottom), (0, 0, 255), cv2.FILLED)
        font = cv2.FONT_HERSHEY_DUPLEX
        cv2.putText(labframe, name, (left + 0, bottom + 18), font, 0.5, (255, 255, 255), 1)

    # Display the resulting image
    #cv2.imshow('Video', frame)
    return labframe

def frame2ba64(frame):

    cnt = cv2.imencode('.jpg',frame)[1]
    ba64 = base64.b64encode(cnt)

    return ba64

######################################################################################
###################################### Main ##########################################

# Get a reference to webcam #0 (the default one)
video_capture = cv2.VideoCapture(0)
video_capture.set(3,960)
video_capture.set(4,720)

#video_capture = cv2.VideoCapture('rtsp://127.0.0.1:5551/Streaming/Channels/1')
#video_capture.set(3,960)
#video_capture.set(4,720)

face_folder = '/home/igrid/facedb/known'
facedb = load_face_db(face_folder)

# Initialize some variables
face_locations = []
face_encodings = []
face_names = []
process_this_frame = True

known_people = 'unknown'
scan_ratio = 0.75

frame_delay=5
while True:
    # Grab a single frame of video
    ret, frame = video_capture.read()

    # Resize frame of video to 1/2 size for faster face recognition processing
    small_frame = cv2.resize(frame, (0, 0), fx=scan_ratio, fy=scan_ratio)
    #small_frame = frame

    # Only process every other frame of video to save time
    if process_this_frame:
        # Find all the faces and face encodings in the current frame of video
        small_face_locations = face_recognition.face_locations(small_frame)
        face_locations = []
        for (lt,lr,lb,ll) in small_face_locations:
            locat = ( int(math.ceil(lt/scan_ratio)),int(math.ceil(lr/scan_ratio)),int(math.ceil(lb/scan_ratio)),int(math.ceil(ll/scan_ratio)) )
            face_locations.append(locat)

        face_encodings = face_recognition.face_encodings(frame, face_locations)
        face_names = []
        found_people = ("unknown",1,[])
        for face_encoding in face_encodings:
            # See if the face is a match for the known face(s)

            result = find_face(facedb,face_encoding)
            lname = "unknown"

            if result['match']:
                lname = result['name'] + ' ' + "{:3.2f}".format((1-result['distance'])*100) + '%'
                found_people = (result['name'],result['distance'],face_encoding)
            else:
                found_people = ("unknown",1,face_encoding)

            face_names.append(lname)

        if found_people[0] != known_people and len(face_encodings) == 1:
            ba64frame = frame2ba64(frame)
            ba64lab = frame2ba64(label_frame(frame,face_locations,face_names))

            if found_people[0] != "unknown":
                frame_delay = 5

            if found_people[0] != "unknown" or frame_delay==0:
                print 'found => ' + found_people[0]
                known_people = found_people[0]
                fea = [x for x in found_people[2]]
                send_to_bigstream(found_people[0],found_people[1],fea,ba64frame,ba64lab)


        if frame_delay > 0:
            frame_delay = frame_delay-1


    process_this_frame = not process_this_frame




    # Hit 'q' on the keyboard to quit!
    if cv2.waitKey(1) & 0xFF == ord('q'):
        break

# Release handle to the webcam
video_capture.release()
cv2.destroyAllWindows()
