How to Use

1. Configure the Notification Service
   You need to create a configuration dictionary for both Gmail and/or Telegram. The configuration should look like this:

```python
config = {
   "gmail": {
      "smtp_server": "smtp.gmail.com", # SMTP server
      "smtp_port": "587", # SMTP port
      "sender_email": "your_email@gmail.com", # Gmail sender email
      "sender_password": "your_password", # Gmail sender password
   },
   "telegram": {
      "bot_token": "your_bot_token", # Telegram bot token
      "chat_id": "your_chat_id", # The chat ID to send messages to
   }
}
```

2. Initialize the Notification Service

```python
from notification_service import NotificationService
notification_service = NotificationService(config)
```

3. Send a Notification
   To send a notification, pass the method ("gmail" or "telegram") and the parameters related to the respective method.

Example:

Sending a Gmail Notification:

```python
from src.strategies.gmail import MessageParams

gmail_params:MessageParams = {
   "to"  : ["poramet.tan@nectec.or.th"],
   "subject" : "Test Notification",
   "body" : f"""
            Hello World
      """,
   "cc" : ["poramet.tan@nectec.or.th"]
}

notification_params = {
   "method": "gmail",
   "params": gmail_params
}

notification_service.send_notification(notification_params)
```

Sending a Telegram Notification:

```python
from src.strategies.telegram import MessageParams

telegram_params:MessageParams =  {
   "text" :f"""Hello World"""
}

notification_params = {
   "method": "telegram",
   "params": telegram_params
}

notification_service.send_notification(notification_params)
```
