import smtplib
from typing import Optional,TypedDict
from email.mime.text import MIMEText
from email.mime.multipart import MIMEMultipart
import src.config as _config
from .notification_strategy import NotificationStrategy



class MessageParams(TypedDict):
    to : list[str]
    cc : Optional[list[str]]
    subject : str
    body : str


class Gmail(NotificationStrategy):
    
    _smtp_server : str
    _smtp_port :str
    _sender_mail : str
    _sender_pass : str

    def __init__(self,smtp_server:str,smtp_port:str):
        self._smtp_server = smtp_server
        self._smtp_port = smtp_port
    def set_sender(self,mail:str,password:str):
        self._sender_mail =  mail
        self._sender_pass = password
        
    def send(self,params:MessageParams):
        with smtplib.SMTP_SSL(self._smtp_server,self._smtp_port) as smtp:
            smtp.login(self._sender_mail,self._sender_pass)
            
            _to = params['to']
            _cc = params['cc'] if 'cc' in params else []
            msg = MIMEMultipart()
            msg['From'] = self._sender_mail
            msg['To'] = ",".join(_to)
            msg['Subject'] = params['subject']
            if len(_cc):
                msg["CC"] = ",".join(_cc)
                
            msg.attach(MIMEText(params['body'],'plain'))
            
            text = msg.as_string()
            toaddrs = _to + _cc
            
            smtp.sendmail(self._sender_mail,toaddrs,text)



if __name__ == '__main__':
    params = {
        "to"  : ["poramet.tan@nectec.or.th"],
        "subject" : "Test Notification",
        "body" : f"""
                Hello World
            """,
        "cc" : ["poramet.tan@nectec.or.th"]
    }
    
    gmail  =  Gmail(_config.DEFAULT_SMTP_SERVER,_config.DEFAULT_SMTP_PORT)
    gmail.set_sender(_config.DEFAULT_GMAIL_APP_EMAIL,_config.DEFAULT_GMAIL_APP_PASS)
    gmail.send(params)