How to install

```bash
pip install git+https://git.igridproject.info/porrametict/notification_center.git
```

How to Use

1. Configure the Notification center
   You need to create a configuration dictionary for both Gmail and/or Telegram. The configuration should look like this:

```python
config = {
   "gmail": {
      "smtp_server": "smtp.gmail.com", # SMTP server
      "smtp_port": "587", # SMTP port
      "sender_email": "your_email@gmail.com", # Gmail sender email
      "sender_password": "your_password", # Gmail sender password
   },
   "telegram": {
      "bot_token": "your_bot_token", # Telegram bot token
      "chat_id": "your_chat_id", # The chat ID to send messages to
   }
}
```

2. Initialize the Notification center

```python
from notification_center import NotificationCenter
notification_center = NotificationCenter(config)
```

3. Send a Notification
   To send a notification, pass the method ("gmail" or "telegram") and the parameters related to the respective method.

Example:

Sending a Gmail Notification:

```python

gmail_params = {
   "to"  : ["poramet.tan@nectec.or.th"],
   "subject" : "Test Notification",
   "body" : f"""
            Hello World
      """,
   "cc" : ["poramet.tan@nectec.or.th"]
}

notification_params = {
   "method": "gmail",
   "params": gmail_params
}

notification_center.send_notification(notification_params)
```

Sending a Telegram Notification:

```python

telegram_params =  {
   "text" :f"""Hello World"""
}

notification_params = {
   "method": "telegram",
   "params": telegram_params
}

notification_center.send_notification(notification_params)
```
