from typing import Union

from .strategies.gmail import MessageParams as GmailMessageParams
from .strategies.telegram import MessageParams as TelegramMessageParams
from .strategies.notification_strategy import NotificationStrategy

class NotificationSender:
            
    def set_strategy(self,strategy:NotificationStrategy):
        self._strategy = strategy
    
    def send_notification(self,params:Union[GmailMessageParams,TelegramMessageParams],raise_error:bool=False):
        if raise_error:
            self._strategy.send(params)
        else :
            try:
                self._strategy.send(params)
            except Exception as e :
                pass # do nothing
            
