import requests
from typing import TypedDict

from .notification_strategy import NotificationStrategy


class MessageParams(TypedDict):
    text : str


class Telegram(NotificationStrategy):

    _bot_token :str
    _chat_id :str
    
    
    def __init__(self,bot_token:str,chat_id:str):
        self._bot_token = bot_token
        self._chat_id = chat_id
    
    def send(self,params:MessageParams):
        
        request_params = {
            "chat_id": self._chat_id,
            "text" : params['text']
        }
        url = f"https://api.telegram.org/bot{self._bot_token}/sendMessage"
        requests.get(url,params=request_params)
        

# if __name__ == '__main__':
#     import src.config as _config
#     params = {
#         "text" :f"""
#           Hello World
#         """,
#     }
#     tg = Telegram(_config.TG_BOT_TOKEN,_config.TG_CHAT_ID)
#     tg.send(params)