import React, { useState } from 'react';
import DesignManagement from './DesignManagement';
import { styled } from '@mui/material/styles';
import MenuEditor from './MenuEditor';
import { Collapse } from '@mui/material';
import ToolEdit from './ToolEdit';
import { ReactFlowProvider } from 'reactflow';

const StyledContainer = styled('div')`
    display: flex;
    min-height: 100vh;
`;

const StyledLeftComponent = styled('div')`
    // width: '20%';
`;

const StyledRightComponent = styled('div')`
    flex: 1;
    // width: 100%;
`;

const LeftComponent = () => {
    return (
        <StyledLeftComponent>
            <MenuEditor />
        </StyledLeftComponent>
    )
}

const RightComponent = () => {
    return (
        <StyledRightComponent>
            <ReactFlowProvider>
                <DesignManagement />
            </ReactFlowProvider>
        </StyledRightComponent>
    )
}

const Main = () => {

    const [open, setOpen] = useState(false);

    return (
        <StyledContainer>
            <ToolEdit setOpen={setOpen} open={open} />
            <Collapse in={open} timeout="auto" orientation='horizontal' collapsedSize='0px' unmountOnExit>
                <LeftComponent />
            </Collapse>
            <RightComponent />
        </StyledContainer>
    );
}

export default Main;