import { Button } from '@mui/material';
import { styled } from '@mui/material/styles';

const Container = styled('div')`
    width: 60px;
    min-height: 100vh;
    background: #455a64;
`;

const ButtonMui = styled(Button)`
    background: #455a64;
    border: 1px solid #ffffff;
    min-width: 10px;
    min-height: 20px;
    margin-top: 10px;
    padding: 5px 10px;
`;

const ToolEdit = (props) => {

    const { setOpen, open } = props;

    const handleToggle = () => {
        setOpen(!open);
    };

    return (
        <Container>
            <ButtonMui variant="contained" onClick={handleToggle}>{open ? '<<' : '>>'}</ButtonMui>
        </Container>
    );
}

export default ToolEdit;